<?php
defined('PF_VERSION') OR exit('Access denied');
$referer = !empty($_GET['ref']) ? urldecode($_GET['ref']) : public_base_url();
$form_displayname = array('name' => 'displayname', 'placeholder' => __('Display Name', 'user'));
$form_username = array('name' => 'username', 'placeholder' => __('Username', 'user'));
$form_email = array('name' => 'email', 'placeholder' => __('Email', 'user'));
$settings = Pf::setting();
$allow = $settings->get_element_value('pf_user', 'allow_reg');
$min_user = $settings->get_element_value('pf_user', 'user_length');
$min_pass = $settings->get_element_value('pf_user', 'pass_length');
$captcha    =   get_captcha();
if ($captcha!=FALSE) 
    require_once ABSPATH . '/includes/recaptchalib.php';
if (!is_login()) {
    $auth = new Auth();
    if (!empty($_POST)) {
        if ($_POST['type'] == 'register') {
            if ($allow == 1) {
                if (!empty($_POST['igree']) && $_POST['igree'] == 1) {
                        if ($captcha != FALSE) {
                            $resp = recaptcha_check_answer($captcha['privatekey'], $_SERVER["REMOTE_ADDR"], $_POST["recaptcha_challenge_field"], $_POST["recaptcha_response_field"]);
                            if (!$resp->is_valid) {
                                $error[][0] = __("Wrong Captcha Code", 'user');
                            }
                        }
                    $v = Pf::validator();
                    $_POST = $v->sanitize($_POST);
                    $v->validation_rules(array(
                        "displayname" => "required|max_len,20|min_len,1",
                        "username" => "required|alpha_numeric|max_len,20|min_len,{$min_user}",
                        "email" => "required|valid_email",
                        "password" => "required|max_len,20|min_len,{$min_pass}",
                        "repassword" => "required|max_len,20|min_len,{$min_pass}"
                    ));
                    $validate = $v->run($_POST);
                    if ($validate === false) {
                        $error = $v->get_readable_errors(false);
                        foreach ($error as $key => $value) {
                            $error[$key][0] = $error[$key][0] . " [" . $key . "]";
                        }
                    } else {
                        $displayname = $_POST['displayname'];
                        $username = $_POST['username'];
                        $email = $_POST['email'];
                        $password = $_POST['password'];
                        $repassword = $_POST['repassword'];
                        if ($auth->is_username_exist($username)) {
                            $error['username'][0] = __("Username is already in use!", 'user');
                        }
                        if ($auth->is_email_exist($email)) {
                            $error['email'][0] = __("Email is already in use!", "user");
                        }
                        if ($password != $repassword) {
                            $error['repassword'][0] = __("Passwords do not match", 'user');
                        }
                    }
                    if (empty($error)) {
                        $auth->register(array(
                            'user-email'=>$email,
                            'user-name'=>$username,
                            'displayname'=>$_POST['displayname'],
                            'password'=>$password,
                            'role'=>5
                        ));
                        $notif = __("Please check your email to active this account.", 'user');
                        if (Pf::setting()->get_element_value('pf_user', 'activa_require') == 1) {
                            $error['success'][0] = __("Your account has been registered!", 'user') . $notif;
                            $register_success   =   1;
                        } else {
                            set_session($auth->get_identity());
                            $_SESSION['register_success']=$username;
                            header('location: ' . $userpage . "/user-action:register");
                        }
                    }
                } else {
                    $error[][0] = __("Please agree to the Terms of Service and Privacy Policy first!", 'user');
                }
            }
        }
    }
    require_once 'views/views-register.php';
} elseif (!empty($_SESSION['register_success'])) {
    require 'views/views-welcome.php';
    unset($_SESSION['register_success']);
} else
    header('location: ' . public_base_url());